<?php $__env->startSection('body-class', 'page-my-plugins'); ?>

<?php $__env->startSection('title', __('panel/menu.plugins')); ?>

<?php $__env->startSection('content'); ?>
  <div class="card h-min-600">
    <div class="card-header">
      <ul class="nav nav-tabs mb-2" id="myTab">
        <li class="nav-item">
          <a class="nav-link <?php echo e($type == '' ? 'active' : 'fw-normal'); ?>" type="button" href="<?php echo e(panel_route('plugins.index')); ?>">
            <?php echo e(__('panel/plugin.all')); ?>

          </a>
        </li>
        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="nav-item">
            <a class="nav-link <?php echo e($item==$type ? 'active' : 'fw-normal'); ?>" type="button" href="<?php echo e(panel_route('plugins.index', ['type'=>$item])); ?>">
              <?php echo e(__('panel/plugin.'.$item)); ?>

            </a>
          </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <div class="card-body">
      <div class="row">
        <?php if(count($plugins)): ?>
        <?php $__currentLoopData = $plugins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-6 col-md-3 mb-4">
            <div class="plugin-item" data-code="<?php echo e($plugin['code']); ?>"
                 data-installed="<?php echo e($plugin['installed'] ? 1 : 0); ?>">
              <div class="image-wrap">
                <div class="image"><img src="<?php echo e($plugin['icon']); ?>" alt="<?php echo e($plugin['name']); ?>" class="img-fluid"></div>
                <div class="title"><?php echo e($plugin['name']); ?></div>
              </div>

              <div class="plugin-info">
                <div class="description"><?php echo e($plugin['description']); ?></div>
                <div class="d-flex justify-content-between align-items-center">
                  <div class="version">
                    <div class="d-flex align-items-center">
                      <div class="form-switch plugin-enabled-switch cursor-pointer">
                        <input class="form-check-input" type="checkbox"
                               <?php echo e(!$plugin['installed'] ? 'disabled' : ''); ?> role="switch" <?php echo e($plugin['enabled'] ? 'checked' : ''); ?>>
                      </div>
                    </div>
                  </div>
                  <div class="btns">
                    <?php if($plugin['installed']): ?>
                      <?php if($plugin['edit_url']): ?>
                        <a href="<?php echo e($plugin['edit_url']); ?>" class="btn btn-primary btn-sm"><?php echo e(__('panel/common.edit')); ?></a>
                      <?php endif; ?>
                      <div class="btn btn-danger btn-sm uninstall-plugin"><?php echo e(__('panel/common.uninstall')); ?></div>
                    <?php else: ?>
                      <div class="btn btn-primary btn-sm install-plugin"><?php echo e(__('panel/common.install')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
          <?php if (isset($component)) { $__componentOriginal295d9e45e90747fdb30f4db07eae728c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal295d9e45e90747fdb30f4db07eae728c = $attributes; } ?>
<?php $component = InnoShop\Common\Components\NoData::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('common-no-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\InnoShop\Common\Components\NoData::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $attributes = $__attributesOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $component = $__componentOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__componentOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
  <script>
    $(function () {
      $('.install-plugin').click(function () {
        var code = $(this).parents('.plugin-item').data('code');
        pluginsUpdata(code, 'install');
      });

      $('.uninstall-plugin').click(function () {
        var code = $(this).parents('.plugin-item').data('code');
        pluginsUpdata(code, 'uninstall');
      });
    });

    $('.plugin-enabled-switch input').change(function () {
      var code = $(this).parents('.plugin-item').data('code');
      var enabled = $(this).prop('checked') ? 1 : 0;
      axios.post('/<?php echo e(panel_name()); ?>/plugins/enabled', {code: code, enabled: enabled}).then(function (res) {
        if (res.success) {
          window.location.reload();
        } else {
          inno.alert(res.message);
        }
      });
    });

    function pluginsUpdata(code, type) {
      const url = type === 'install' ? '/<?php echo e(panel_name()); ?>/plugins' : '/<?php echo e(panel_name()); ?>/plugins/' + code;
      const method = type === 'install' ? 'post' : 'delete';

      axios[method](url, {code: code}).then(function (res) {
        if (res.success) {
          window.location.reload();
        } else {
          inno.alert(res.message);
        }
      });
    }
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('panel::layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\inno\innopacks/plugin/resources/views/plugins/index.blade.php ENDPATH**/ ?>