<?php $__env->startSection('title', __('panel/menu.file_manager')); ?>

<?php $__env->startPrepend('header'); ?>
    <meta name="api-token" content="<?php echo e(auth()->user()->api_token); ?>">
<?php $__env->stopPrepend(); ?>

<?php $__env->startPush('header'); ?>
<style>
    body {
        display: flex;
        flex-direction: column;
        height: 100vh;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    /* 主内容区域 */
    .content-wrapper {
        overflow: hidden;
        position: relative;
    }

    /* 文件管理器内容区域 */
    .file-manager {
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    /* 文件列表区域 */
    .file-list {
        flex: 1;
        overflow-y: auto;
        padding: 20px;
    }

    /* 底部按钮固定在底部 */
    .page-bottom-btns {
        height: 60px;
        padding: 10px;
        background: #fff;
        border-top: 1px solid #EBEEF5;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        z-index: 10;
    }

    /* 左侧文件夹树 */
    .folder-tree {
        height: 100%;
        border-right: 1px solid #EBEEF5;
        overflow-y: auto;
    }

    /* 工具栏样式 */
    .file-toolbar {
        padding: 15px 20px;
        border-bottom: 1px solid #EBEEF5;
        background: #fff;
        position: relative;
        z-index: 10;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('footer'); ?>
<script>
    // 创建底部按钮的 Vue 实例
    new Vue({
        el: '#bottom-btns',
        methods: {
            handleConfirm() {
                // 获取主 Vue 实例并调用其方法
                const mainApp = document.querySelector('#app').__vue__;
                if (mainApp && typeof mainApp.confirmSelection === 'function') {
                    mainApp.confirmSelection();
                }
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<div class="content-wrapper">
    <?php echo $__env->make('panel::file_manager.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<?php $__env->startSection('page-bottom-btns'); ?>
<div class="page-bottom-btns" id="bottom-btns">
    <button class="btn btn-primary" @click="handleConfirm">选择提交</button>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('panel::layouts.blank', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/file_manager/iframe.blade.php ENDPATH**/ ?>