<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(panel_locale_direction()); ?>">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <base href="<?php echo e(panel_route('home.index')); ?>">
  <title><?php echo $__env->yieldContent('title', __('panel/login.title')); ?></title>
  <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', __('panel/login.keywords')); ?>">
  <meta name="description" content="<?php echo $__env->yieldContent('description', __('panel/login.description')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link rel="shortcut icon" href="<?php echo e(asset('images/favicon.png')); ?>">
  <link rel="stylesheet" href="<?php echo e(mix('build/panel/css/bootstrap.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(mix('build/panel/css/app.css')); ?>">
  <script src="<?php echo e(asset('vendor/jquery/jquery-3.7.1.min.js')); ?>"></script>
  <script src="<?php echo e(mix('build/panel/js/app.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/layer/3.5.1/layer.js')); ?>"></script>
  <?php echo $__env->yieldPushContent('header'); ?>
</head>
<body class="page-login">
  <div class="">
    <div class="container vh-100 pt-2 pt-sm-5 pb-4 pb-sm-5">
      <div class="locale-wrap">
        <div class="d-flex align-items-center locale">
          <div class="wh-20 me-2"><img src="<?php echo e(image_origin('images/flag/'. panel_locale_code().'.png')); ?>" class="img-fluid"></div>
          <span class=""><?php echo e(current_panel_locale()['name']); ?> <i class="bi bi-chevron-down"></i></span>
          <ul class="dropdown-menu">
            <?php $__currentLoopData = panel_locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
              <a class="dropdown-item d-flex" href="<?php echo e(panel_route('login.index', ['locale'=> $locale['code']])); ?>">
                <div class="wh-20 me-2"><img src="<?php echo e(image_origin($locale['image'])); ?>" class="img-fluid"></div>
                <?php echo e($locale['name']); ?>

              </a>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="login-wrap">
        <div class="card login-content">
            <div class="card-header">
              <h3 class="fw-bold text-center"><?php echo e(__('panel/login.login_index')); ?></h3>
            </div>

            <div class="card-body">
              <form action="<?php echo e(panel_route('login.store')); ?>" method="post">
                <?php echo csrf_field(); ?>

                <div class="form-floating mb-4">
                  <input type="text" name="email" class="form-control" id="email-input" value="<?php echo e(old('email', $admin_email ?? '')); ?>" placeholder="<?php echo e(__('common.email')); ?>">
                  <label for="email-input"><?php echo e(__('panel/login.email')); ?></label>
                  <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-floating mb-5">
                  <input type="password" name="password" class="form-control" id="password-input" value="<?php echo e(old('password', $admin_password ?? '')); ?>" placeholder="<?php echo e(__('shop/login.password')); ?>">
                  <label for="password-input"><?php echo e(__('panel/login.password')); ?></label>
                  <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <?php if(session('error')): ?>
                  <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                  </div>
                <?php endif; ?>

                <div class="d-grid mb-4"><button type="submit" class="btn btn-lg btn-primary"><?php echo e(__('panel/common.btn_submit')); ?></button></div>
              </form>
            </div>
        </div>
        <p class="text-center text-secondary mt-5">
          <a href="https://www.innoshop.com" class="ms-2" target="_blank">InnoShop</a>
          <?php echo e(innoshop_version()); ?> &copy; <?php echo e(date('Y')); ?> All Rights Reserved
        </p>
      </div>

    </div>
  </div>
</body>
</html>
<?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/login.blade.php ENDPATH**/ ?>