<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'คุณต้องยอมรับ :attribute.',
    'accepted_if'     => 'คุณต้องยอมรับ :attribute เมื่อ :other เป็น :value.',
    'active_url'      => ':attribute ไม่ใช่ URL ที่ถูกต้อง.',
    'after'           => ':attribute ต้องเป็นวันที่หลังจาก :date.',
    'after_or_equal'  => ':attribute ต้องเท่ากับหรือหลังจาก :date.',
    'alpha'           => ':attribute สามารถประกอบด้วยตัวอักษรเท่านั้น.',
    'alpha_dash'      => ':attribute สามารถประกอบด้วยตัวอักษร, ตัวเลข, ขีดกลาง (-) และขีดล่าง (_).',
    'alpha_num'       => ':attribute สามารถประกอบด้วยตัวอักษรและตัวเลขเท่านั้น.',
    'array'           => ':attribute ต้องเป็นอาเรย์.',
    'before'          => ':attribute ต้องเป็นวันที่ก่อน :date.',
    'before_or_equal' => ':attribute ต้องเท่ากับหรือก่อน :date.',
    'between'         => [
        'array'   => ':attribute ต้องมีระหว่าง :min - :max รายการ.',
        'file'    => ':attribute ต้องมีขนาดระหว่าง :min - :max KB.',
        'numeric' => ':attribute ต้องอยู่ระหว่าง :min - :max.',
        'string'  => ':attribute ต้องมีความยาวระหว่าง :min - :max ตัวอักษร.',
    ],
    'boolean'          => ':attribute ต้องเป็นค่าบูลีน.',
    'confirmed'        => ':attribute ยืนยันไม่ตรงกัน.',
    'current_password' => 'รหัสผ่านไม่ถูกต้อง.',
    'date'             => ':attribute ไม่ใช่วันที่ที่ถูกต้อง.',
    'date_equals'      => ':attribute ต้องเท่ากับ :date.',
    'date_format'      => ':attribute ต้องมีรูปแบบเป็น :format.',
    'declined'         => ':attribute ต้องถูกปฏิเสธ.',
    'declined_if'      => 'เมื่อ :other เป็น :value, :attribute ต้องถูกปฏิเสธ.',
    'different'        => ':attribute และ :other ต้องแตกต่างกัน.',
    'digits'           => ':attribute ต้องเป็นตัวเลข :digits หลัก.',
    'digits_between'   => ':attribute ต้องมีตัวเลขระหว่าง :min และ :max หลัก.',
    'dimensions'       => 'ขนาดภาพของ :attribute ไม่ถูกต้อง.',
    'distinct'         => ':attribute มีอยู่แล้ว.',
    'email'            => ':attribute ไม่ใช่อีเมลที่ถูกต้อง.',
    'ends_with'        => ':attribute ต้องจบด้วย :values.',
    'enum'             => 'ค่าของ :attribute ไม่ถูกต้อง.',
    'exists'           => ':attribute ไม่อยู่ในระบบ.',
    'file'             => ':attribute ต้องเป็นไฟล์.',
    'filled'           => ':attribute ต้องมีค่า.',
    'gt'               => [
        'array'   => ':attribute ต้องมีมากกว่า :value รายการ.',
        'file'    => ':attribute ต้องมีขนาดมากกว่า :value KB.',
        'numeric' => ':attribute ต้องมากกว่า :value.',
        'string'  => ':attribute ต้องมีความยาวมากกว่า :value ตัวอักษร.',
    ],
    'gte' => [
        'array'   => ':attribute ต้องมีมากกว่าหรือเท่ากับ :value รายการ.',
        'file'    => ':attribute ต้องมีขนาดมากกว่าหรือเท่ากับ :value KB.',
        'numeric' => ':attribute ต้องมากกว่าหรือเท่ากับ :value.',
        'string'  => ':attribute ต้องมีความยาวมากกว่าหรือเท่ากับ :value ตัวอักษร.',
    ],
    'image'    => ':attribute ต้องเป็นภาพ.',
    'in'       => 'ค่าที่เลือก :attribute ไม่ถูกต้อง.',
    'in_array' => ':attribute ต้องอยู่ใน :other.',
    'integer'  => ':attribute ต้องเป็นจำนวนเต็ม.',
    'ip'       => ':attribute ต้องเป็นที่อยู่ IP ที่ถูกต้อง.',
    'ipv4'     => ':attribute ต้องเป็นที่อยู่ IPv4 ที่ถูกต้อง.',
    'ipv6'     => ':attribute ต้องเป็นที่อยู่ IPv6 ที่ถูกต้อง.',
    'json'     => ':attribute ต้องเป็นรูปแบบ JSON ที่ถูกต้อง.',
    'lt'       => [
        'array'   => ':attribute ต้องมีน้อยกว่า :value รายการ.',
        'file'    => ':attribute ต้องมีขนาดน้อยกว่า :value KB.',
        'numeric' => ':attribute ต้องน้อยกว่า :value.',
        'string'  => ':attribute ต้องมีความยาวน้อยกว่า :value ตัวอักษร.',
    ],
    'lte' => [
        'array'   => ':attribute ต้องมีน้อยกว่าหรือเท่ากับ :value รายการ.',
        'file'    => ':attribute ต้องมีขนาดน้อยกว่าหรือเท่ากับ :value KB.',
        'numeric' => ':attribute ต้องน้อยกว่าหรือเท่ากับ :value.',
        'string'  => ':attribute ต้องมีความยาวน้อยกว่าหรือเท่ากับ :value ตัวอักษร.',
    ],
    'mac_address' => ':attribute ต้องเป็นที่อยู่ MAC ที่ถูกต้อง.',
    'max'         => [
        'array'   => ':attribute ต้องมีไม่เกิน :max รายการ.',
        'file'    => ':attribute ต้องไม่เกิน :max KB.',
        'numeric' => ':attribute ต้องไม่เกิน :max.',
        'string'  => ':attribute ต้องไม่เกิน :max ตัวอักษร.',
    ],
    'mimes'     => ':attribute ต้องเป็นไฟล์ประเภท :values.',
    'mimetypes' => ':attribute ต้องเป็นไฟล์ประเภท :values.',
    'min'       => [
        'array'   => ':attribute ต้องมีอย่างน้อย :min รายการ.',
        'file'    => ':attribute ขนาดต้องไม่ต่ำกว่า :min KB.',
        'numeric' => ':attribute ต้องมีค่ามากกว่าหรือเท่ากับ :min.',
        'string'  => ':attribute ต้องมีความยาวอย่างน้อย :min ตัวอักษร.',
    ],
    'multiple_of'          => ':attribute ต้องเป็นหลายเท่าของ :value.',
    'not_in'               => 'ค่าที่เลือก :attribute ไม่ถูกต้อง.',
    'not_regex'            => 'รูปแบบของ :attribute ไม่ถูกต้อง.',
    'numeric'              => ':attribute ต้องเป็นตัวเลข.',
    'password'             => 'รหัสผ่านไม่ถูกต้อง.',
    'present'              => ':attribute ต้องมีอยู่.',
    'prohibited'           => 'ฟิลด์ :attribute ถูกห้าม.',
    'prohibited_if'        => 'เมื่อ :other เป็น :value, ฟิลด์ :attribute ถูกห้าม.',
    'prohibited_unless'    => 'ฟิลด์ :attribute ถูกห้าม เว้นแต่ :other อยู่ใน :values.',
    'prohibits'            => 'ฟิลด์ :attribute ห้ามให้มี :other.',
    'regex'                => 'รูปแบบของ :attribute ไม่ถูกต้อง.',
    'required'             => ':attribute ต้องมีค่า.',
    'required_array_keys'  => ':attribute ต้องมีคีย์ที่ระบุ: :values.',
    'required_if'          => 'เมื่อ :other เป็น :value, :attribute ต้องมีค่า.',
    'required_unless'      => 'เมื่อ :other ไม่อยู่ใน :values, :attribute ต้องมีค่า.',
    'required_with'        => 'เมื่อ :values มีอยู่, :attribute ต้องมีค่า.',
    'required_with_all'    => 'เมื่อ :values มีอยู่, :attribute ต้องมีค่า.',
    'required_without'     => 'เมื่อ :values ไม่มีอยู่, :attribute ต้องมีค่า.',
    'required_without_all' => 'เมื่อ :values ทั้งหมดไม่มีอยู่, :attribute ต้องมีค่า.',
    'same'                 => ':attribute และ :other ต้องตรงกัน.',
    'size'                 => [
        'array'   => ':attribute ต้องมี :size รายการ.',
        'file'    => ':attribute ขนาดต้องเป็น :size KB.',
        'numeric' => ':attribute ขนาดต้องเป็น :size.',
        'string'  => ':attribute ต้องมีความยาว :size ตัวอักษร.',
    ],
    'starts_with' => ':attribute ต้องเริ่มต้นด้วย:values.',
    'string'      => ':attribute ต้องเป็นสตริง.',
    'timezone'    => ':attribute ต้องเป็นโซนเวลาที่ถูกต้อง.',
    'unique'      => ':attribute ถูกใช้ไปแล้ว.',
    'uploaded'    => ':attribute UPLOAD ล้มเหลว.',
    'url'         => 'รูปแบบของ :attribute ไม่ถูกต้อง.',
    'uuid'        => ':attribute ต้องเป็น UUID ที่ถูกต้อง.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
