<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'Vous devez accepter :attribute.',
    'accepted_if'     => 'Vous devez accepter :attribute lorsque :other est :value.',
    'active_url'      => ':attribute n\'est pas une URL valide.',
    'after'           => ':attribute doit être postérieure à :date.',
    'after_or_equal'  => ':attribute doit être postérieure ou égale à :date.',
    'alpha'           => ':attribute ne doit contenir que des lettres.',
    'alpha_dash'      => ':attribute ne doit contenir que des lettres, des chiffres, des tirets et des underscores.',
    'alpha_num'       => ':attribute ne doit contenir que des lettres et des chiffres.',
    'array'           => ':attribute doit être un tableau.',
    'before'          => ':attribute doit être antérieure à :date.',
    'before_or_equal' => ':attribute doit être antérieure ou égale à :date.',
    'between'         => [
        'array'   => ':attribute doit contenir entre :min et :max éléments.',
        'file'    => ':attribute doit peser entre :min et :max Ko.',
        'numeric' => ':attribute doit être entre :min et :max.',
        'string'  => ':attribute doit contenir entre :min et :max caractères.',
    ],
    'boolean'          => ':attribute doit être une valeur booléenne.',
    'confirmed'        => 'Les valeurs de :attribute ne correspondent pas.',
    'current_password' => 'Mot de passe incorrect.',
    'date'             => ':attribute n\'est pas une date valide.',
    'date_equals'      => ':attribute doit être égale à :date.',
    'date_format'      => ':attribute doit être au format :format.',
    'declined'         => ':attribute doit être refusé.',
    'declined_if'      => 'Le champ :attribute doit être refusé si :other est :value.',
    'different'        => ':attribute et :other doivent être différents.',
    'digits'           => ':attribute doit être un nombre à :digits chiffres.',
    'digits_between'   => ':attribute doit être un nombre entre :min et :max chiffres.',
    'dimensions'       => 'Les dimensions de l\'image :attribute sont incorrectes.',
    'distinct'         => 'La valeur de :attribute est déjà utilisée.',
    'email'            => ':attribute n\'est pas un email valide.',
    'ends_with'        => ':attribute doit se terminer par l\'une des valeurs suivantes :values.',
    'enum'             => 'La valeur de :attribute est invalide.',
    'exists'           => 'La valeur de :attribute est invalide.',
    'file'             => ':attribute doit être un fichier.',
    'filled'           => ':attribute ne peut pas être vide.',
    'gt'               => [
        'array'   => ':attribute doit contenir plus de :value éléments.',
        'file'    => ':attribute doit être plus grand que :value Ko.',
        'numeric' => ':attribute doit être supérieur à :value.',
        'string'  => ':attribute doit contenir plus de :value caractères.',
    ],
    'gte' => [
        'array'   => ':attribute doit contenir au moins :value éléments.',
        'file'    => ':attribute doit être au moins de :value Ko.',
        'numeric' => ':attribute doit être au moins de :value.',
        'string'  => ':attribute doit contenir au moins :value caractères.',
    ],
    'image'    => ':attribute doit être une image.',
    'in'       => 'Le champ :attribute sélectionné est invalide.',
    'in_array' => ':attribute doit être présent dans :other.',
    'integer'  => ':attribute doit être un nombre entier.',
    'ip'       => ':attribute doit être une adresse IP valide.',
    'ipv4'     => ':attribute doit être une adresse IPv4 valide.',
    'ipv6'     => ':attribute doit être une adresse IPv6 valide.',
    'json'     => ':attribute doit être un format JSON valide.',
    'lt'       => [
        'array'   => ':attribute doit contenir moins de :value éléments.',
        'file'    => ':attribute doit être plus petit que :value Ko.',
        'numeric' => ':attribute doit être inférieur à :value.',
        'string'  => ':attribute doit contenir moins de :value caractères.',
    ],
    'lte' => [
        'array'   => ':attribute doit contenir au plus :value éléments.',
        'file'    => ':attribute doit être au plus de :value Ko.',
        'numeric' => ':attribute doit être au plus de :value.',
        'string'  => ':attribute doit contenir au plus de :value caractères.',
    ],
    'mac_address' => ':attribute doit être une adresse MAC valide.',
    'max'         => [
        'array'   => ':attribute ne doit pas contenir plus de :max éléments.',
        'file'    => ':attribute ne doit pas être plus grand que :max Ko.',
        'numeric' => ':attribute ne doit pas être supérieur à :max.',
        'string'  => ':attribute ne doit pas contenir plus de :max caractères.',
    ],
    'mimes'     => ':attribute doit être un fichier de type :values.',
    'mimetypes' => ':attribute doit être un fichier de type :values.',
    'min'       => [
        'array'   => ':attribute doit contenir au moins :min éléments.',
        'file'    => ':attribute doit peser au moins :min Ko.',
        'numeric' => ':attribute doit être au moins de :min.',
        'string'  => ':attribute doit contenir au moins :min caractères.',
    ],
    'multiple_of'          => ':attribute doit être un multiple de :value.',
    'not_in'               => 'Le champ :attribute sélectionné est invalide.',
    'not_regex'            => 'Le format de :attribute est invalide.',
    'numeric'              => ':attribute doit être un nombre.',
    'password'             => 'Mot de passe incorrect',
    'present'              => ':attribute doit être présent.',
    'prohibited'           => 'Le champ :attribute est interdit.',
    'prohibited_if'        => 'Le champ :attribute est interdit si :other est :value.',
    'prohibited_unless'    => 'Le champ :attribute est interdit, sauf si :other est dans :values.',
    'prohibits'            => 'Le champ :attribute interdit :other.',
    'regex'                => 'Le format de :attribute est invalide.',
    'required'             => ':attribute ne peut pas être vide.',
    'required_array_keys'  => ':attribute doit contenir au moins les clés suivantes :values.',
    'required_if'          => 'Le champ :attribute est obligatoire si :other est :value.',
    'required_unless'      => 'Le champ :attribute est obligatoire sauf si :other est dans :values.',
    'required_with'        => 'Le champ :attribute est obligatoire si :values est présent.',
    'required_with_all'    => 'Le champ :attribute est obligatoire si :values sont présents.',
    'required_without'     => 'Le champ :attribute est obligatoire si :values n\'est pas présent.',
    'required_without_all' => 'Le champ :attribute est obligatoire si aucun de :values n\'est présent.',
    'same'                 => ':attribute et :other doivent être identiques.',
    'size'                 => [
        'array'   => ':attribute doit contenir :size éléments.',
        'file'    => ':attribute doit peser :size Ko.',
        'numeric' => ':attribute doit être :size.',
        'string'  => ':attribute doit contenir :size caractères.',
    ],
    'starts_with' => ':attribute doit commencer par l\'une des valeurs suivantes :values.',
    'string'      => ':attribute doit être une chaîne decaractères.',
    'timezone'    => ':attribute doit être un fuseau horaire valide.',
    'unique'      => 'La valeur de :attribute est déjà utilisée.',
    'uploaded'    => 'Le fichier :attribute n\'a pas été uploadé.',
    'url'         => 'Le format de :attribute est invalide.',
    'uuid'        => ':attribute doit être un UUID valide.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
